//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 1 lights, 4 materials and 9 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.2 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 07/21/2000    (21.07.2000)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <      0.168,     -43.674,      19.673>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35836,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         40.00000    // Vertical      30.000
  look_at   <      0.000,       0.000,       0.000>
}

//
// *******  L I G H T S *******
//

light_source {   // Light1
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  translate  <0.0, -20.0, 20.0>
}


//
// ********  MATERIALS  *******
//

#include "mundo2.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

 #declare SPIRAL1 = 
 blob {
    threshold .75
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,0.400,0.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,0.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,0.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,0.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,0.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,0.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,0.000,0.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,1.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,1.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,1.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,1.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,1.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,-0.400,1.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,1.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,2.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,2.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,2.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,2.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,-0.000,2.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,2.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,3.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,3.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,3.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,3.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,0.400,3.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,3.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,3.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,4.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,4.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,4.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,0.000,4.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,4.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,4.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,4.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,5.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,5.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,-0.400,5.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,5.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,5.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,5.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,6.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,6.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,-0.000,6.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,6.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,6.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,6.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,6.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,7.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,0.400,7.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,7.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,7.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,7.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,7.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,7.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,0.000,8.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,8.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,8.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,8.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,8.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,8.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,-0.400,9.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,9.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,9.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,9.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,9.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,9.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,-0.000,9.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,10.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,10.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,10.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,10.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,10.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,0.400,10.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,10.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,11.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,11.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,11.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,11.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,-0.000,11.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,11.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,12.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,12.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,12.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,12.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,-0.400,12.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,12.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,12.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,13.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,13.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,13.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,0.000,13.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,13.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,13.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,13.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,14.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,14.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,0.400,14.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,14.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,14.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,14.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,15.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,15.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,-0.000,15.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,15.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,15.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,15.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,15.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,16.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,-0.400,16.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,16.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,16.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,16.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,16.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,16.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,0.000,17.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,17.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,17.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,17.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,17.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,17.870>
      }
   }
 #declare SPIRAL2 = 
 blob {
    threshold .75
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,-0.400,0.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,0.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,0.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,0.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,0.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,0.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,-0.000,0.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,1.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,1.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,1.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,1.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,1.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,0.400,1.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,1.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,2.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,2.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,2.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,2.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,0.000,2.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,2.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,3.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,3.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,3.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,3.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,-0.400,3.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,3.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,3.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,4.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,4.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,4.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,-0.000,4.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,4.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,4.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,4.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,5.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,5.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,0.400,5.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,5.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,5.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,5.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,6.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,6.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,0.000,6.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,6.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,6.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,6.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,6.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,7.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,-0.400,7.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,7.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,7.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,7.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,7.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,7.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,-0.000,8.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,8.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,8.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,8.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,8.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,8.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,0.400,9.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,9.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,9.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,9.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,9.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,9.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,0.000,9.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,10.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,10.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,10.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,10.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,10.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,-0.400,10.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,10.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,11.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,11.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,11.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,11.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,0.000,11.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,11.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,12.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,12.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,12.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,12.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,0.400,12.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,12.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,12.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,13.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,13.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,13.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,-0.000,13.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,13.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,13.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,13.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,14.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,14.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,-0.400,14.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,14.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,14.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,14.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,15.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,15.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,0.000,15.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,15.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,15.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,15.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,15.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,16.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,0.400,16.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,16.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,16.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,16.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,16.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,16.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,-0.000,17.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,17.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,17.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,17.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,17.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,17.870>
      }
      }
 #declare SPIRAL = merge{
 object{SPIRAL1} 
 object{SPIRAL2} 
 } 
  #declare CUTSPIRAL = difference {
    object { SPIRAL }
    box { // Cube001
      <-1.5, -1.5, -1.5>, <1.5, 1.5, 1.5>
      translate  17.6*z
    }
    box { // Cube002
      <-1.5, -1.5, -1.5>, <1.5, 1.5, 1.5>
      translate  -1.9*z
    }
  }
union
{// Spiral Column
  object { CUTSPIRAL }
  box
  { // Cube001
     <-1, -1, -1>, <1, 1, 1>
     scale <1.6, 1.6, 0.3>
     translate  <0,0,16.450>
  }
  torus
  { // Torus001
     1.5, 0.5  rotate -x*90
     scale <0.7, 0.7, 0.325>
     translate  <0,0,16.000>
  }
  torus 
  { // Torus002
     1.5, 0.5  rotate -x*90
     scale <0.7, 0.7, 0.45>
     translate <0,0, -0.125>
  }
  box 
  { // Cube002
     <-1, -1, -1>, <1, 1, 1>
     scale <1.6, 1.6, 0.3>
     translate  <0,0,-0.35>
  }
   rotate <0.000, 0.000, 0.000>
   scale <1.000, 1.000, 1.000>
   translate <0.000, 9.003, -16.851>
material {Alabaster}
}


#declare galaxy_bg                       = true;
#declare galaxy_objects                  = true;
#declare galaxy_starfield                = true;
#declare options_only                    = false;
#declare galaxy_seed                     = 0.000;
#declare galaxy_colour                   = <1.000,1.000,1.000>;
#declare galaxy_colouration              = 0.500;
#declare galaxy_colour_turb              = 0.200;
#declare galaxy_intensity                = 1.000;
#declare galaxy_rotate                   = <-90.000,180.000,0.000>;
#declare galaxy_distance                 = 10000.000;
#declare galaxy_origin                   = <0.000,0.000,0.000>;
#declare galaxy_bgstars                  = 2.000;
#declare galaxy_bgnebula                 = 1.000;
#declare galaxy_nebula_sphere            = 1.000;
#declare galaxy_nebula_ambient           = <1.000,1.000,1.000>;
#declare galaxy_colour1                  = <1.000,1.000,1.000>;
#declare galaxy_colour2                  = <1.000,1.000,1.000>;
#declare galaxy_colour3                  = <1.000,1.000,1.000>;
#declare galaxy_star_colouration         = 0.200;
#declare galaxy_pattern_scale            = 1.000;
#declare galaxy_pattern_origin           = <0.000,0.000,0.000>;
#declare galaxy_turb_origin              = <0.000,0.000,0.000>;
#declare galaxy_declare_only             = false;
#declare star_count                      = 1000.000;
#declare star_colour                     = <0.900,0.900,0.900>;
#declare star_type                       = 1.000;
#declare star_scale                      = 1.000;
#declare star_distance                   = 20000.000;
#declare star_spread                     = 1.000;
#declare star_distribution               = 1.000;
#declare star_colour_turb                = <0.200,0.200,0.200>;
#declare star_brightness_turb            = 0.500;
#include "GALAXY.sf"
#declare galaxy_object_name              = "Nebula1"
#declare galaxy_object_scale             = 1.000;
#declare galaxy_object_rotate            = 0.000;
#declare galaxy_object_flatten           = 0.200;
#declare galaxy_object_position          = <0.000,0.000,0>;
#declare galaxy_cluster_name             = "Star1"
#declare galaxy_cluster_objects          = 6.000;
#declare galaxy_cluster_scale            = 0.500;
#declare galaxy_cluster_rotate           = 0.000;
#declare galaxy_cluster_spread           = 15.000;
#declare galaxy_scale_turb               = 0.500;
#declare galaxy_rotate_turb              = 0.000;
#include "GALAXY.obj"
#include "Galaxy.inc"


object {   // HgtFld001
  height_field {
    tga "C:\Daniel\irtc proj\hffinal2.tga"
    water_level 0.5
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    Ceramic___WhiteBump
  }
  scale <7.0, 7.0, 0.3>
  translate  0.5*z
}


disc { // Disc001
  <0,0,0>, <0,0,1>, 1.0
  material {
    ocean_color
  }
  scale <9.0, 9.0, 1.0>
  translate  0.5*z
}


merge {  // RndDisc001
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.8000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.8000, 0.8000, 1.0200> translate -0.0900*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-1.0020, -1.0020, 0.7980>, <1.0020, 1.0020, 1.0020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  material {
    Material1
  }
  scale <10.0, 10.0, 1.0>
}




 #declare SPIRAL1 = 
 blob {
    threshold .75
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,0.400,0.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,0.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,0.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,0.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,0.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,0.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,0.000,0.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,1.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,1.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,1.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,1.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,1.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,-0.400,1.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,1.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,2.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,2.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,2.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,2.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,-0.000,2.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,2.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,3.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,3.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,3.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,3.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,0.400,3.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,3.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,3.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,4.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,4.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,4.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,0.000,4.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,4.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,4.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,4.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,5.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,5.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,-0.400,5.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,5.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,5.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,5.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,6.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,6.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,-0.000,6.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,6.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,6.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,6.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,6.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,7.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,0.400,7.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,7.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,7.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,7.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,7.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,7.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,0.000,8.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,8.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,8.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,8.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,8.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,8.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,-0.400,9.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,9.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,9.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,9.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,9.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,9.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,-0.000,9.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,10.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,10.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,10.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,10.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,10.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,0.400,10.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,10.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,11.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,11.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,11.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,11.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,-0.000,11.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,11.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,12.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,12.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,12.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,12.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,-0.400,12.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,12.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,12.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,13.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,13.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,13.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,0.000,13.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,13.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,13.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,13.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,14.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,14.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,0.400,14.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,14.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,14.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,14.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,15.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,15.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,-0.000,15.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,15.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,15.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,15.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,15.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,16.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,-0.400,16.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,16.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,16.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,16.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,16.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,16.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,0.000,17.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,17.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,17.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,17.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,17.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,17.870>
      }
   }
 #declare SPIRAL2 = 
 blob {
    threshold .75
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,-0.400,0.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,0.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,0.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,0.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,0.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,0.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,-0.000,0.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,1.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,1.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,1.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,1.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,1.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,0.400,1.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,1.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,2.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,2.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,2.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,2.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,0.000,2.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,2.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,3.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,3.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,3.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,3.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,-0.400,3.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,3.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,3.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,4.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,4.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,4.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,-0.000,4.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,4.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,4.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,4.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,5.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,5.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,0.400,5.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,5.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,5.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,5.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,6.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,6.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,0.000,6.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,6.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,6.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,6.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,6.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,7.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,-0.400,7.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,7.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,7.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,7.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,7.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,7.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,-0.000,8.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,8.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,8.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,8.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,8.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,8.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,0.400,9.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,9.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,9.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,9.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,9.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,9.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,0.000,9.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,10.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,10.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,10.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,10.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,10.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,-0.400,10.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,10.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,11.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,11.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,11.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,11.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,0.000,11.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,11.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,12.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,12.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,12.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,12.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,0.400,12.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,12.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,12.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,13.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,13.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,13.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,-0.000,13.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,13.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,13.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,13.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,14.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,14.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,-0.400,14.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,14.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,14.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,14.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,15.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,15.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,0.000,15.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,15.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,15.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,15.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,15.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,16.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,0.400,16.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,16.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,16.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,16.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,16.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,16.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,-0.000,17.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,17.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,17.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,17.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,17.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,17.870>
      }
      }
 #declare SPIRAL = merge{
 object{SPIRAL1} 
 object{SPIRAL2} 
 } 
  #declare CUTSPIRAL = difference {
    object { SPIRAL }
    box { // Cube001
      <-1.5, -1.5, -1.5>, <1.5, 1.5, 1.5>
      translate  17.6*z
    }
    box { // Cube002
      <-1.5, -1.5, -1.5>, <1.5, 1.5, 1.5>
      translate  -1.9*z
    }
  }
union
{// Spiral Column
  object { CUTSPIRAL }
  box
  { // Cube001
     <-1, -1, -1>, <1, 1, 1>
     scale <1.6, 1.6, 0.3>
     translate  <0,0,16.450>
  }
  torus
  { // Torus001
     1.5, 0.5  rotate -x*90
     scale <0.7, 0.7, 0.325>
     translate  <0,0,16.000>
  }
  torus 
  { // Torus002
     1.5, 0.5  rotate -x*90
     scale <0.7, 0.7, 0.45>
     translate <0,0, -0.125>
  }
  box 
  { // Cube002
     <-1, -1, -1>, <1, 1, 1>
     scale <1.6, 1.6, 0.3>
     translate  <0,0,-0.35>
  }
   rotate <0.000, 0.000, 0.000>
   scale <1.000, 1.000, 1.000>
   translate <-8.867, 0.273, -16.851>
material {Alabaster}
}


 #declare SPIRAL1 = 
 blob {
    threshold .75
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,0.400,0.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,0.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,0.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,0.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,0.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,0.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,0.000,0.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,1.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,1.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,1.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,1.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,1.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,-0.400,1.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,1.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,2.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,2.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,2.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,2.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,-0.000,2.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,2.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,3.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,3.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,3.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,3.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,0.400,3.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,3.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,3.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,4.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,4.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,4.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,0.000,4.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,4.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,4.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,4.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,5.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,5.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,-0.400,5.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,5.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,5.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,5.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,6.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,6.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,-0.000,6.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,6.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,6.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,6.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,6.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,7.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,0.400,7.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,7.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,7.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,7.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,7.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,7.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,0.000,8.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,8.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,8.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,8.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,8.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,8.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,-0.400,9.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,9.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,9.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,9.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,9.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,9.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,-0.000,9.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,10.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,10.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,10.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,10.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,10.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,0.400,10.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,10.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,11.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,11.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,11.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,11.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,-0.000,11.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,11.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,12.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,12.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,12.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,12.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,-0.400,12.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,12.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,12.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,13.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,13.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,13.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,0.000,13.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,13.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,13.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,13.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,14.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,14.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,0.400,14.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,14.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,14.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,14.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,15.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,15.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,-0.000,15.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,15.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,15.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,15.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,15.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,16.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,-0.400,16.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,16.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,16.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,16.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,16.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,16.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,0.000,17.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,17.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,17.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,17.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,17.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,17.870>
      }
   }
 #declare SPIRAL2 = 
 blob {
    threshold .75
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,-0.400,0.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,0.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,0.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,0.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,0.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,0.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,-0.000,0.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,1.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,1.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,1.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,1.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,1.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,0.400,1.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,1.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,2.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,2.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,2.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,2.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,0.000,2.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,2.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,3.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,3.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,3.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,3.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,-0.400,3.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,3.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,3.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,4.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,4.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,4.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,-0.000,4.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,4.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,4.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,4.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,5.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,5.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,0.400,5.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,5.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,5.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,5.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,6.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,6.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,0.000,6.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,6.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,6.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,6.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,6.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,7.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,-0.400,7.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,7.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,7.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,7.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,7.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,7.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,-0.000,8.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,8.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,8.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,8.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,8.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,8.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,0.400,9.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,9.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,9.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,9.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,9.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,9.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,0.000,9.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,10.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,10.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,10.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,10.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,10.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,-0.400,10.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,10.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,11.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,11.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,11.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,11.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,0.000,11.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,11.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,12.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,12.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,12.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,12.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,0.400,12.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,12.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,12.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,13.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,13.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,13.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,-0.000,13.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,13.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,13.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,13.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,14.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,14.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,-0.400,14.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,14.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,14.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,14.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,15.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,15.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,0.000,15.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,15.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,15.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,15.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,15.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,16.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,0.400,16.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,16.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,16.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,16.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,16.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,16.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,-0.000,17.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,17.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,17.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,17.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,17.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,17.870>
      }
      }
 #declare SPIRAL = merge{
 object{SPIRAL1} 
 object{SPIRAL2} 
 } 
  #declare CUTSPIRAL = difference {
    object { SPIRAL }
    box { // Cube001
      <-1.5, -1.5, -1.5>, <1.5, 1.5, 1.5>
      translate  17.6*z
    }
    box { // Cube002
      <-1.5, -1.5, -1.5>, <1.5, 1.5, 1.5>
      translate  -1.9*z
    }
  }
union
{// Spiral Column
  object { CUTSPIRAL }
  box
  { // Cube001
     <-1, -1, -1>, <1, 1, 1>
     scale <1.6, 1.6, 0.3>
     translate  <0,0,16.450>
  }
  torus
  { // Torus001
     1.5, 0.5  rotate -x*90
     scale <0.7, 0.7, 0.325>
     translate  <0,0,16.000>
  }
  torus 
  { // Torus002
     1.5, 0.5  rotate -x*90
     scale <0.7, 0.7, 0.45>
     translate <0,0, -0.125>
  }
  box 
  { // Cube002
     <-1, -1, -1>, <1, 1, 1>
     scale <1.6, 1.6, 0.3>
     translate  <0,0,-0.35>
  }
   rotate <0.000, 0.000, 0.000>
   scale <1.000, 1.000, 1.000>
   translate <9.003, 0.409, -16.851>
material {Alabaster}
}


 #declare SPIRAL1 = 
 blob {
    threshold .75
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,0.400,0.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,0.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,0.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,0.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,0.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,0.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,0.000,0.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,1.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,1.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,1.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,1.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,1.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,-0.400,1.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,1.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,2.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,2.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,2.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,2.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,-0.000,2.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,2.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,3.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,3.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,3.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,3.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,0.400,3.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,3.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,3.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,4.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,4.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,4.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,0.000,4.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,4.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,4.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,4.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,5.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,5.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,-0.400,5.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,5.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,5.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,5.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,6.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,6.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,-0.000,6.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,6.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,6.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,6.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,6.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,7.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,0.400,7.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,7.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,7.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,7.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,7.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,7.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,0.000,8.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,8.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,8.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,8.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,8.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,8.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,-0.400,9.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,9.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,9.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,9.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,9.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,9.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,-0.000,9.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,10.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,10.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,10.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,10.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,10.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,0.400,10.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,10.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,11.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,11.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,11.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,11.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,-0.000,11.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,11.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,12.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,12.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,12.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,12.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,-0.400,12.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,12.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,12.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,13.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,13.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,13.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,0.000,13.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,13.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,13.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,13.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,14.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,14.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,0.400,14.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,14.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,14.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,14.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,15.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,15.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,-0.000,15.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,15.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,15.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,15.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,15.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,16.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,-0.400,16.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,16.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,16.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,16.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,16.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,16.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,0.000,17.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,17.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,17.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,17.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,17.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,17.870>
      }
   }
 #declare SPIRAL2 = 
 blob {
    threshold .75
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,-0.400,0.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,0.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,0.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,0.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,0.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,0.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,-0.000,0.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,1.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,1.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,1.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,1.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,1.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,0.400,1.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,1.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,2.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,2.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,2.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,2.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,0.000,2.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,2.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,3.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,3.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,3.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,3.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,-0.400,3.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,3.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,3.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,4.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,4.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,4.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,-0.000,4.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,4.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,4.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,4.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,5.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,5.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,0.400,5.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,5.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,5.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,5.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,6.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,6.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,0.000,6.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,6.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,6.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,6.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,6.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,7.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,-0.400,7.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,7.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,7.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,7.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,7.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,7.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,-0.000,8.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,8.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,8.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,8.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,8.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,8.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,0.400,9.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,9.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,9.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,9.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,9.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,9.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,0.000,9.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,10.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,10.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,10.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,10.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,10.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,-0.400,10.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,10.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,11.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,11.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,11.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,11.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,0.000,11.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,11.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,12.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,12.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,12.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,12.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,0.400,12.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,12.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,12.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,13.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,13.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,13.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,-0.000,13.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,13.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,13.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,13.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,14.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,14.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.000,-0.400,14.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,-0.386,14.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,-0.346,14.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,-0.283,14.870>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,-0.200,15.020>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,-0.104,15.170>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.400,0.000,15.320>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.386,0.104,15.470>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.346,0.200,15.620>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.283,0.283,15.770>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.200,0.346,15.920>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <-0.104,0.386,16.070>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.000,0.400,16.220>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,0.386,16.370>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,0.346,16.520>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,0.283,16.670>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,0.200,16.820>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,0.104,16.970>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.400,-0.000,17.120>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.386,-0.104,17.270>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.346,-0.200,17.420>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.283,-0.283,17.570>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.200,-0.346,17.720>
      }
    sphere {
        <0,0,0>,0.8, 0.85
        scale <0.7,0.7,0.7>
        translate  <0.104,-0.386,17.870>
      }
      }
 #declare SPIRAL = merge{
 object{SPIRAL1} 
 object{SPIRAL2} 
 } 
  #declare CUTSPIRAL = difference {
    object { SPIRAL }
    box { // Cube001
      <-1.5, -1.5, -1.5>, <1.5, 1.5, 1.5>
      translate  17.6*z
    }
    box { // Cube002
      <-1.5, -1.5, -1.5>, <1.5, 1.5, 1.5>
      translate  -1.9*z
    }
  }
union
{// Spiral Column
  object { CUTSPIRAL }
  box
  { // Cube001
     <-1, -1, -1>, <1, 1, 1>
     scale <1.6, 1.6, 0.3>
     translate  <0,0,16.450>
  }
  torus
  { // Torus001
     1.5, 0.5  rotate -x*90
     scale <0.7, 0.7, 0.325>
     translate  <0,0,16.000>
  }
  torus 
  { // Torus002
     1.5, 0.5  rotate -x*90
     scale <0.7, 0.7, 0.45>
     translate <0,0, -0.125>
  }
  box 
  { // Cube002
     <-1, -1, -1>, <1, 1, 1>
     scale <1.6, 1.6, 0.3>
     translate  <0,0,-0.35>
  }
   rotate <0.000, 0.000, 0.000>
   scale <1.000, 1.000, 1.000>
   translate <-0.187, -8.731, -16.851>
material {Alabaster}
}


